package base

import (
	"github.com/gin-gonic/gin"
	"github.com/gogf/gf/i18n/gi18n"
	"strconv"
)

/*
	国际化处理
*/

var (
	t *gi18n.Manager
)

// InternationalizedMsg 国际化msg
func InternationalizedMsg(ctx *gin.Context, code int) string {

	t = gi18n.New()

	languageType := ctx.Request.Header.Get("language")

	// 设置默认语言类型
	if languageType == "" {
		languageType = "zh-CN"
	}
	// 设置语言类型
	t.SetLanguage(languageType)
	// 传入错误码
	stringCode := strconv.Itoa(code)
	// 拿到对应国家的错误信息
	translateMsg := t.Translate(ctx, stringCode)

	return translateMsg
}