package logging

import (
	"fmt"
	"system_pay/setting"

	"time"

)

// getLogFilePath 获取日志文件保存路径
func getLogFilePath() string {
	return fmt.Sprintf("%s" , setting.Conf.LogSetting.LogSavePath)
}

// getLogFileName 获取日志文件的保存名称
func getLogFileName() string {
	return fmt.Sprintf("%s%s.%s",
		setting.Conf.LogSetting.LogSaveName,
		time.Now().Format(setting.Conf.AppSetting.TimeFormat),
		setting.Conf.LogSetting.LogFileExt,
	)
}
