package main

import (
	"bytes"
	"fmt"
	"github.com/fvbock/endless"
	"github.com/gin-gonic/gin"
	"os"
	"os/exec"
	_ "system_pay/docs"
	logger "system_pay/pkg/logging"
	routers "system_pay/router"
	"system_pay/setting"
)

// @title 谛宝多多平台
// @version 1.0
// @description 采购订单项目
// @securityDefinitions.apikey ApiKeyAuth
// @in header
// @name Authorization
func main() {

	if os.Getenv("runmode") == "release" {
		gin.SetMode(gin.ReleaseMode)
	} else {
		gin.SetMode(gin.DebugMode)
	}

	// 设置
	if err := setting.Init(); err != nil {
		panic("load config failed, new_error:"+ err.Error())
		//fmt.Printf("load config failed, new_error:%v\n", new_error)
		//return
	}


	if gin.Mode() == gin.TestMode || gin.Mode() == gin.DebugMode {
		//自动更新swagger
		//runCommand()
	}

	// 日志
	if err := logger.Init(setting.Conf.LogSetting); err != nil {
		panic("init logger failed, new_error:"+ err.Error())
		//fmt.Printf("init logger failed, new_error:%v\n", new_error)
		//return
	}

	// 注册路由
	r := routers.InitRouter()

	// 优雅启停
	err := endless.ListenAndServe(setting.GetPort(), r)
	if err != nil {
		panic("route initialization failed, new_error:"+ err.Error())
		//fmt.Println("route_initialization_failed" + new_error.Error())
		//return

	}

}

// runCommand  重启时候更新swagger
func runCommand() {
	cmd := exec.Command("swag", "init")
	fmt.Println("Cmd", cmd.Args)
	var out bytes.Buffer
	cmd.Stdout = &out
	cmd.Stderr = os.Stderr
	err := cmd.Start()
	if err != nil {
		fmt.Println(err)
	}
	fmt.Println(out.String())
}
