package models

//支付
type PlaceAnOrderParamInput struct {
	PlatformType   uint8   `json:"platform_type"` //平台类型 1:saas 2:shop 3:shop mobile 4:收银台 6:bk_shop 7:bk_shop_mobile
	PlatformInfo   string  `json:"platform_info"` //平台信息
	GoodsDes       string  `json:"goods_des"` //商品描述
	GoodsDetail    string  `json:"goods_detail"` //商品详情
	AttachInfo     string  `json:"attach_info"` //附加信息
	GoodsPrice     float64 `json:"goods_price"` //商品金额,个位为分
	NoticeURL      string  `json:"notice_url"` //客户端回调的url
	PayType        int     `json:"pay_type"` //支付渠道 1:微信 2:支付宝 3:拉卡拉 4:收钱吧
	SourceCode     uint8   `json:"source_code"` //支付方式 1:微信Native 2:微信小程序 3:微信内支付 4:h5 跳微信 5:支付宝(web)-扫码或登录支付宝账户 6:alipay(mobile) 7:alipay(app) 9:B2C 10:bk支付宝web 11:bk 支付宝手机 15:快捷支付(银行卡) 16:微信小程序-必康自营 17:微信JASPI-必康自营
	OpenID         string  `json:"open_id"` //此参数 支付类型是 JS API 的时候 必传
	WapURL         string  `json:"wap_url"` //WAP网站URL地址, 支付方式为微信MWEB时 必传
	WapName        string  `json:"wap_name"` //WAP网站名称, 支付方式为微信MWEB时 必传
	QuitURL        string  `json:"quit_url"` //返回按钮 可用于用户付款中途退出并返回到该参数指定的商户网站地址, 支付方式为 支付宝手机网站时 必传(尽量传)
	ReturnURL      string  `json:"return_url"` //用户在完成支付后，会根据商户在请求支付API中传入的前台回跳地址return_url自动跳转return_url地址页面(必传)
	AppID          string  `json:"app_id,omitempty"` //wxAppId source code 2 小程序支付时必传、同时小程序支付必须关联了商户号支付
	Operator       string  `json:"operator"` //操作员
	Customer       string  `json:"customer"` //顾客信息
	DynamicID      string  `json:"dynamic_id"` //顾客手机条码的内容
	StoreSn        string  `json:"store_sn"` //商户门店编号
	IsServe        uint    `json:"is_serve"` //0直连模式  1服务商模式
	OrderId        string  `json:"-"` //订单号
	SubMchid       string  `json:"sub_mchid"` //通过进件接口申请的支付商户号、这是由微信生成并下发的
	Nonce          string  `json:"-"`
	ServeNoticeUrl string  `json:"-"` //传递给支付渠道的、而不是业务方的
	AuthCodes      string  `json:"auth_codes"` //LAKALA签约协议号列表
}

//退款
type RefundParamInput struct {
	RefundNo     string  `json:"refund_no"` //退款号:原对账单流水号
	RefundAmount float64 `json:"refund_amount"` //退款金额,个位为分
	RefundReason string  `json:"refund_reason"` //退款原因
}

//支付查询
//type OrderStateInput struct {
//	OrderId string `json:"order_id"` //订单号
//}

type LakalaParamInput struct {
	Version string `json:"version"` //版本
	ReqTime string `json:"req_time"` //请求时间
	ReqData LakalaParamData `json:"req_data"`
}

type LakalaParamData struct {
	OutOrderNo   string  `json:"out_order_no"` //商户订单号
	MerchantNo   string  `json:"merchant_no"` //银联商户号

	TotalAmount     float64 `json:"total_amount"` //订单金额，单位：分
	OrderEfficientTime   string  `json:"order_efficient_time"` //订单有效期 格式yyyyMMddHHmmss,最大支持下单时间+2天
	NotifyUrl   string  `json:"notify_url"` //订单支付成功后商户接收订单通知的地址 http://xxx.xxx.com

	CallbackUrl   string  `json:"callback_url"` //客户端下单完成支付后返回的商户网页跳转地址
	OrderInfo   string  `json:"order_info"` //订单标题，在使用收银台扫码支付时必输入，交易时送往账户端
	GoodsMark   string  `json:"goods_mark"` //商品信息标识 （1:含商品信息，不填默认不含商品信息）
}

//订单查询
type OrderState struct {
	State uint8 `json:"state" description:"订单状态 0: 未结算 1: 结算成功 2: 结算失败"`
}