package v1

import (
	"github.com/gin-gonic/gin"
	"system_pay/controller/api/v1/pay"
	"system_pay/router/pack"
)

// 统一支付
func PayRouter (r *gin.Engine) {
	PayController := pay.PayController{}

	// 卡拉卡统一支付
	r.POST(pack.PayUrlPacking("unified_order"), PayController.UnifiedOrder)

	// 卡拉卡统一支付回调(收银台)
	r.POST(pack.PayUrlPacking("cashier_notice"), PayController.CashierNotice)

	// 卡拉卡统一支付回调(聚合扫码)
	r.POST(pack.PayUrlPacking("scan_notice"), PayController.ScanNotice)

	// 拉卡拉支付查询
	r.GET(pack.PayUrlPacking("order_state/:orderId"), PayController.OrderState)

	// 拉卡拉退款
	r.PUT(pack.PayUrlPacking("refund/:orderId/:operator/:money"), PayController.Refund)
}

