# 声明镜像来源为golang:alpine
FROM golang:alpine

# 设置环境变量GO111MODULE为on
ENV GO111MODULE=on

# 设置环境变量GOPROXY为https://goproxy.io,direct
ENV GOPROXY=https://goproxy.cn,direct
# 声明工作目录
WORKDIR /go/src/system_pay


# 拷贝当前工程代码到工作目录
COPY . .

# go env为查看go的环境变量, go build -o server . 为打包项目,二进制
RUN go env && go mod tidy && go build -o server .

# ======= 以下为多阶段构建 =======

# 声明镜像来源为alpine:latest
FROM alpine:latest

ENV TZ=Asia/Shanghai
RUN echo "http://mirrors.aliyun.com/alpine/v3.4/main/" > /etc/apk/repositories \
    && apk --no-cache add tzdata zeromq \
    && ln -snf /usr/share/zoneinfo/$TZ /etc/localtime \
    && echo '$TZ' > /etc/timezone

# 声明工作目录
WORKDIR /go/src/system_pay

# 拷贝打包好的server二进制文件到当前工作目录
COPY --from=0 /go/src/system_pay/server ./

# 拷贝配置文件到当前工作目录
#COPY --from=0 /go/src/system_pay/conf/dev ./conf
COPY --from=0 /go/src/system_pay/conf/prod ./conf

# 拷贝国际化文件夹到当前工作目录
COPY --from=0 /go/src/system_pay/i18n ./i18n

# 拷贝国际化文件夹到当前工作目录
COPY --from=0 /go/src/system_pay/docs ./docs

# 拷贝私钥、公钥和证书文件夹到当前工作目录
COPY --from=0 /go/src/system_pay/cert ./cert
# COPY --from=0 /go/src/system_pay/cert/dev ./cert/dev
COPY --from=0 /go/src/system_pay/cert/prod ./cert/prod
COPY --from=0 /go/src/system_pay/cert/prod/bk ./cert/prod/bk
COPY --from=0 /go/src/system_pay/cert/prod/dbc ./cert/prod/dbc
COPY --from=0 /go/src/system_pay/cert/prod/saas ./cert/prod/saas

# 运行打包好的二进制
ENTRYPOINT ./server