package base

import (
	"github.com/gin-gonic/gin"
	"net/http"
)

/*
{
	"code": 10000, // 程序中的错误码
	"msg": xx,     // 提示信息
	"data": {},    // 数据
}
*/

// ResponseData 统一返回数据
type ResponseData struct {
	Status  int         `json:"Status"`
	Message interface{} `json:"Message"`
	Data    interface{} `json:"Data,omitempty"`
}

// ResponseErrorWithMsg 返回错误
func ResponseErrorWithMsg(c *gin.Context, code int) {
	c.JSON(http.StatusOK, &ResponseData{
		Status: code,
		Message:  InternationalizedMsg(c, code),
		Data: nil,
	})
}

// ResponseSuccess 返回正确
func ResponseSuccess(c *gin.Context, data interface{}) {
	c.JSON(http.StatusOK, &ResponseData{
		Status: Success,
		Message:  InternationalizedMsg(c, Success),
		Data: data,
	})
}

// ResponseErrorMsg 直接返回msg
func ResponseErrorMsg(c *gin.Context, msg string) {
	c.JSON(http.StatusOK, &ResponseData{
		Status: Warning,
		Message:  msg,
		Data: nil,
	})
}

// ResponseDataWxNotice 微信回调后 处理完逻辑返回给微信的信息
type ResponseDataWxNotice struct {
	Code    string `json:"code"` //SUCCESS/FAIL
	Message string `json:"message"`  //执行成功/错误原因
}
func ResponseWxNotice(c *gin.Context, data *ResponseDataWxNotice) {
	c.JSON(http.StatusOK, &ResponseDataWxNotice{
		Code:    data.Code,
		Message: data.Message,
	})
}