// Package docs GENERATED BY THE COMMAND ABOVE; DO NOT EDIT
// This file was generated by swaggo/swag
package docs

import (
	"bytes"
	"encoding/json"
	"strings"
	"text/template"

	"github.com/swaggo/swag"
)

var doc = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{.Description}}",
        "title": "{{.Title}}",
        "contact": {},
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/api/v1/pay/cashier_notice": {
            "post": {
                "description": "拉卡拉统一支付回调(收银台)",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "拉卡拉统一支付回调"
                ],
                "summary": "拉卡拉统一支付回调(收银台)",
                "parameters": [
                    {
                        "description": "参数",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/models.CashierNoticeInput"
                        }
                    },
                    {
                        "type": "string",
                        "description": "语言类型 zh-CN简体中文 en-US英文 ja-JP日文 默认中文",
                        "name": "language",
                        "in": "header"
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    }
                }
            }
        },
        "/api/v1/pay/order_state/{orderId}": {
            "get": {
                "description": "拉卡拉支付查询",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "拉卡拉支付查询"
                ],
                "summary": "拉卡拉支付查询",
                "parameters": [
                    {
                        "type": "string",
                        "description": "订单号",
                        "name": "orderId",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "语言类型 zh-CN简体中文 en-US英文 ja-JP日文 默认中文",
                        "name": "language",
                        "in": "header"
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    }
                }
            }
        },
        "/api/v1/pay/refund/{orderId}/{operator}/{money}": {
            "put": {
                "description": "拉卡拉退款",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "拉卡拉退款"
                ],
                "summary": "拉卡拉退款",
                "parameters": [
                    {
                        "type": "string",
                        "description": "退款号:原对账单流水号",
                        "name": "orderId",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "操作人/退款原因",
                        "name": "operator",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "退款金额,个位为分",
                        "name": "money",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "语言类型 zh-CN简体中文 en-US英文 ja-JP日文 默认中文",
                        "name": "language",
                        "in": "header"
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    }
                }
            }
        },
        "/api/v1/pay/scan_notice": {
            "post": {
                "description": "拉卡拉统一支付回调(聚合扫码)",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "拉卡拉统一支付回调"
                ],
                "summary": "拉卡拉统一支付回调(聚合扫码)",
                "parameters": [
                    {
                        "description": "参数",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/models.ScanNoticeInput"
                        }
                    },
                    {
                        "type": "string",
                        "description": "语言类型 zh-CN简体中文 en-US英文 ja-JP日文 默认中文",
                        "name": "language",
                        "in": "header"
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    }
                }
            }
        },
        "/api/v1/pay/unified_order": {
            "post": {
                "description": "拉卡拉统一支付",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "拉卡拉统一支付"
                ],
                "summary": "拉卡拉统一支付",
                "parameters": [
                    {
                        "description": "参数",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/models.PlaceAnOrderParamInput"
                        }
                    },
                    {
                        "type": "string",
                        "description": "语言类型 zh-CN简体中文 en-US英文 ja-JP日文 默认中文",
                        "name": "language",
                        "in": "header"
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    }
                }
            }
        }
    },
    "definitions": {
        "models.CashierNoticeInput": {
            "type": "object",
            "properties": {
                "channel_id": {
                    "description": "渠道号",
                    "type": "string"
                },
                "merchant_no": {
                    "description": "结算商户号",
                    "type": "string"
                },
                "order_create_time": {
                    "description": "订单创建时间",
                    "type": "string"
                },
                "order_efficient_time": {
                    "description": "订单有效时间",
                    "type": "string"
                },
                "order_info": {
                    "description": "订单描述",
                    "type": "string"
                },
                "order_status": {
                    "description": "订单状态",
                    "type": "string"
                },
                "order_trade_info": {
                    "type": "object"
                },
                "out_order_no": {
                    "description": "商户订单号",
                    "type": "string"
                },
                "pay_order_no": {
                    "description": "支付订单号",
                    "type": "string"
                },
                "split_info": {
                    "type": "object"
                },
                "term_no": {
                    "description": "结算终端号",
                    "type": "string"
                },
                "total_amount": {
                    "description": "订单金额，单位：分",
                    "type": "integer"
                },
                "trans_merchant_no": {
                    "description": "交易商户号",
                    "type": "string"
                },
                "trans_term_no": {
                    "description": "交易终端号",
                    "type": "string"
                }
            }
        },
        "models.PlaceAnOrderParamInput": {
            "type": "object",
            "properties": {
                "app_id": {
                    "description": "wxAppId source code 2 小程序支付时必传、同时小程序支付必须关联了商户号支付",
                    "type": "string"
                },
                "attach_info": {
                    "description": "附加信息",
                    "type": "string"
                },
                "auth_codes": {
                    "description": "LAKALA签约协议号列表",
                    "type": "string"
                },
                "customer": {
                    "description": "顾客信息",
                    "type": "string"
                },
                "dynamic_id": {
                    "description": "顾客手机条码的内容",
                    "type": "string"
                },
                "goods_des": {
                    "description": "商品描述",
                    "type": "string"
                },
                "goods_detail": {
                    "description": "商品详情",
                    "type": "string"
                },
                "goods_price": {
                    "description": "商品金额,个位为分",
                    "type": "number"
                },
                "is_serve": {
                    "description": "0直连模式  1服务商模式",
                    "type": "integer"
                },
                "notice_url": {
                    "description": "客户端回调的url",
                    "type": "string"
                },
                "open_id": {
                    "description": "此参数 支付类型是 JS API 的时候 必传",
                    "type": "string"
                },
                "operator": {
                    "description": "操作员",
                    "type": "string"
                },
                "pay_type": {
                    "description": "支付渠道 1:微信 2:支付宝 3:拉卡拉 4:收钱吧",
                    "type": "integer"
                },
                "platform_info": {
                    "description": "平台信息",
                    "type": "string"
                },
                "platform_type": {
                    "description": "平台类型 1:saas 2:shop 3:shop mobile 4:收银台 6:bk_shop 7:bk_shop_mobile",
                    "type": "integer"
                },
                "quit_url": {
                    "description": "返回按钮 可用于用户付款中途退出并返回到该参数指定的商户网站地址, 支付方式为 支付宝手机网站时 必传(尽量传)",
                    "type": "string"
                },
                "return_url": {
                    "description": "用户在完成支付后，会根据商户在请求支付API中传入的前台回跳地址return_url自动跳转return_url地址页面(必传)",
                    "type": "string"
                },
                "source_code": {
                    "description": "支付方式 1:微信Native 2:微信小程序 3:微信内支付 4:h5 跳微信 5:支付宝(web)-扫码或登录支付宝账户 6:alipay(mobile) 7:alipay(app) 9:B2C 10:bk支付宝web 11:bk 支付宝手机 15:快捷支付(银行卡) 16:微信小程序-必康自营 17:微信JASPI-必康自营",
                    "type": "integer"
                },
                "store_sn": {
                    "description": "商户门店编号",
                    "type": "string"
                },
                "sub_mchid": {
                    "description": "通过进件接口申请的支付商户号、这是由微信生成并下发的",
                    "type": "string"
                },
                "wap_name": {
                    "description": "WAP网站名称, 支付方式为微信MWEB时 必传",
                    "type": "string"
                },
                "wap_url": {
                    "description": "WAP网站URL地址, 支付方式为微信MWEB时 必传",
                    "type": "string"
                }
            }
        },
        "models.ScanNoticeInput": {
            "type": "object",
            "properties": {
                "acc_activity_id": {
                    "description": "活动ID",
                    "type": "string"
                },
                "acc_discount_amount": {
                    "description": "账户端优惠金额",
                    "type": "string"
                },
                "acc_mdiscount_amount": {
                    "description": "商户侧优惠金额（账户端）",
                    "type": "string"
                },
                "acc_other_discount_amount": {
                    "description": "账户端其它优惠金额（待上线）",
                    "type": "string"
                },
                "acc_settle_amount": {
                    "description": "账户端结算金额",
                    "type": "string"
                },
                "acc_trade_no": {
                    "description": "账户端交易订单号",
                    "type": "string"
                },
                "account_type": {
                    "description": "钱包类型",
                    "type": "string"
                },
                "bank_type": {
                    "description": "付款银行",
                    "type": "string"
                },
                "card_type": {
                    "description": "银行卡类型",
                    "type": "string"
                },
                "hb_fq_pay_info": {
                    "description": "花呗分期支付信息（未上线）",
                    "type": "object"
                },
                "log_no": {
                    "description": "拉卡拉对账单流水号",
                    "type": "string"
                },
                "merchant_no": {
                    "description": "商户号",
                    "type": "string"
                },
                "out_trade_no": {
                    "description": "商户交易流水号",
                    "type": "string"
                },
                "payer_amount": {
                    "description": "付款人实付金额",
                    "type": "string"
                },
                "remark": {
                    "description": "备注",
                    "type": "string"
                },
                "settle_merchant_no": {
                    "description": "结算商户号",
                    "type": "string"
                },
                "settle_term_no": {
                    "description": "结算终端号",
                    "type": "string"
                },
                "total_amount": {
                    "description": "订单金额",
                    "type": "string"
                },
                "trade_no": {
                    "description": "拉卡拉交易流水号",
                    "type": "string"
                },
                "trade_status": {
                    "description": "交易状态",
                    "type": "string"
                },
                "trade_time": {
                    "description": "交易完成时间",
                    "type": "string"
                },
                "user_id1": {
                    "description": "用户标识1",
                    "type": "string"
                },
                "user_id2": {
                    "description": "用户标识2",
                    "type": "string"
                }
            }
        }
    },
    "securityDefinitions": {
        "ApiKeyAuth": {
            "type": "apiKey",
            "name": "Authorization",
            "in": "header"
        }
    }
}`

type swaggerInfo struct {
	Version     string
	Host        string
	BasePath    string
	Schemes     []string
	Title       string
	Description string
}

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = swaggerInfo{
	Version:     "1.0",
	Host:        "",
	BasePath:    "",
	Schemes:     []string{},
	Title:       "谛宝多多平台",
	Description: "采购订单项目",
}

type s struct{}

func (s *s) ReadDoc() string {
	sInfo := SwaggerInfo
	sInfo.Description = strings.Replace(sInfo.Description, "\n", "\\n", -1)

	t, err := template.New("swagger_info").Funcs(template.FuncMap{
		"marshal": func(v interface{}) string {
			a, _ := json.Marshal(v)
			return string(a)
		},
	}).Parse(doc)
	if err != nil {
		return doc
	}

	var tpl bytes.Buffer
	if err := t.Execute(&tpl, sInfo); err != nil {
		return doc
	}

	return tpl.String()
}

func init() {
	swag.Register(swag.Name, &s{})
}
