package models

//聚合收银台-交易通知(回调输入参数)
type CashierNoticeInput struct {
	ChannelId          string `json:"channel_id"` //渠道号
	MerchantNo         string `json:"merchant_no"` //结算商户号
	OrderCreateTime    string `json:"order_create_time"` //订单创建时间
	OrderEfficientTime string `json:"order_efficient_time"` //订单有效时间
	OrderInfo          string `json:"order_info"` //订单描述
	OrderStatus        string `json:"order_status"` //订单状态
	OutOrderNo         string `json:"out_order_no"` //商户订单号
	PayOrderNo         string `json:"pay_order_no"` //支付订单号
	TermNo             string `json:"term_no"` //结算终端号
	TotalAmount        int64  `json:"total_amount"` //订单金额，单位：分
	TransMerchantNo    string `json:"trans_merchant_no"` //交易商户号
	TransTermNo        string `json:"trans_term_no"` //交易终端号
	OrderTradeInfo     interface{} `json:"order_trade_info"`
	SplitInfo          interface{} `json:"split_info"`
}
//聚合扫码-交易通知(回调输入参数)
type ScanNoticeInput struct {
	MerchantNo             string      `json:"merchant_no"` //商户号
	OutTradeNo             string      `json:"out_trade_no"` //商户交易流水号
	TradeNo                string      `json:"trade_no"` //拉卡拉交易流水号
	LogNo                  string      `json:"log_no"` //拉卡拉对账单流水号
	AccTradeNo             string      `json:"acc_trade_no"` //账户端交易订单号
	AccountType            string      `json:"account_type"` //钱包类型
	SettleMerchantNo       string      `json:"settle_merchant_no"` //结算商户号
	SettleTermNo           string      `json:"settle_term_no"` //结算终端号
	TradeStatus            string      `json:"trade_status"` //交易状态
	TotalAmount            string      `json:"total_amount"` //订单金额
	PayerAmount            string      `json:"payer_amount"` //付款人实付金额
	AccSettleAmount        string      `json:"acc_settle_amount"` //账户端结算金额
	AccMdiscountAmount     string      `json:"acc_mdiscount_amount"` //商户侧优惠金额（账户端）
	AccDiscountAmount      string      `json:"acc_discount_amount"` //账户端优惠金额
	AccOtherDiscountAmount string      `json:"acc_other_discount_amount"` //账户端其它优惠金额（待上线）
	TradeTime              string      `json:"trade_time"` //交易完成时间
	UserId1                string      `json:"user_id1"` //用户标识1
	UserId2                string      `json:"user_id2"` //用户标识2
	AccActivityId          string      `json:"acc_activity_id"` //活动ID
	BankType               string      `json:"bank_type"` //付款银行
	CardType               string      `json:"card_type"` //银行卡类型
	Remark                 string      `json:"remark"` //备注
	HbFqPayInfo            interface{} `json:"hb_fq_pay_info"` //花呗分期支付信息（未上线）
}

// CallbackResponse is 回调给业务方的信息
type CallbackResponse struct {
	OutTradeNo    string `json:"out_trade_no"`   // 订单号
	ReturnMsg     string `json:"return_msg"`     // 是否成功
	AttachInfo    string `json:"attach_info"`    // 附加信息
	TransactionID string `json:"transaction_id"` // 微信支付订单号
	TradeNo       string `json:"trade_no"`       // 支付宝交易流水号
	AuthCode      string `json:"auth_code"`      // 拉卡拉签约协议号列表
}
