package mysql

import (
	"database/sql"
	_ "github.com/go-sql-driver/mysql"
	"system_pay/setting"
)

var (
	systemdb  *sql.DB
	err error
)

// NewPayConn is 连接支付库
func NewPayConn() (*sql.DB, error) {
	if systemdb == nil {
		//systemdb, err = sql.Open("mysql", beego.AppConfig.String("PayURL"))
		systemdb, err = sql.Open("mysql", setting.Conf.DatabaseSetting.SystemDB)
		//systemdb, err = sqlx.Connect("mysql", setting.Conf.DatabaseSetting.SystemDB)
		return systemdb, err
	}
	return systemdb, nil
}

// CloseTx is 有错误则关闭事务、没错则提交事务
func CloseTx(tx *sql.Tx, err error) {
	if err != nil {
		tx.Rollback()
	}
	tx.Commit()
}