package pay

import (
	"database/sql"
	"encoding/json"
	"fmt"
	"system_pay/controller/base"
	"system_pay/models"
	"system_pay/mysql"
)

// 拉卡拉支付回调(收银台)
func CashierNotice(input *models.CashierNoticeInput) (*base.ResponseDataWxNotice, error) {

	fmt.Println("拉卡拉回调(收银台)输入参数")
	fmt.Println(input)

	response := new(base.ResponseDataWxNotice)

	//db, err := mysql.NewShopConn()
	//if err != nil {
	//	response.Code = "FAIL"
	//	response.Message = "参数格式校验错误"
	//	return response, err
	//}

	// 插入数据库
	db, err := mysql.NewPayConn()
	if err != nil {
		return response, err
	}

	tx, err := db.Begin()
	if err != nil {
		return response, err
	}

	defer mysql.CloseTx(tx, err)

	fmt.Println("111")

	//1.订单存在check
	var billID int64
	var attach, url string
	err = db.QueryRow("select ifnull(id, 0), attach, notify_pay_url from system_pay_bill where payment_order_code = ?",
		input.OutOrderNo).Scan(&billID, &attach, &url)
	if err != nil || billID == 0 || billID == 2 {
		response.Code = "FAIL"
		response.Message = "db operation fail1"
		return response, err
	}

	fmt.Println("222")

	//if noticeRequest.ReturnCode == "SUCCESS" {
		// 把订单状态置为 结算成功
		err = BillPayStateSuccess(tx, billID)
		if err != nil {
			//beego.Error("微信回调, 根据订单id 把订单置为结算成功 失败: ", err)
			//response.ReturnCode = "FAIL"
			//response.ReturnMsg = "db operation fail"
			//return response, nil
			response.Code = "FAIL"
			response.Message = "db operation fail2"
			InsertPayBillDetailNoticeResponseBody(tx, billID, response)
			return response, err
		}
	//} else {
	//
	//	// 把订单状态置为 结算失败
	//	err = repository.BillPayStateFail(tx, billID)
	//	if err != nil {
	//		beego.Error("微信回调, 根据订单id 把订单置为结算成功 失败: ", err)
	//		response.ReturnCode = "FAIL"
	//		response.ReturnMsg = "db operation fail"
	//		return response, nil
	//	}
	//}

	//2.「拉卡拉返回数据」存入 notice_request_body
	err = InsertPayBillDetailNoticeRequestBody(tx, billID, input)
	if err != nil {
		//beego.Error("微信回调, 根据订单id 插入回调Request参数 失败: ", err)
		response.Code = "FAIL"
		response.Message = "db operation fail3"
		InsertPayBillDetailNoticeResponseBody(tx, billID, response)
		return response, err
	}

	fmt.Println("333")

	//3.拉卡拉订收银台订单查询 - check todo

	//3.存入 notice_response_body
	//err = InsertPayBillDetailNoticeResponseBody(billID, response)
	//if err != nil {
	//	beego.Error("微信回调, 根据订单id 插入回调Response参数 失败: ", err)
	//	response.ReturnCode = "FAIL"
	//	response.ReturnMsg = "db operation fail"
	//	return err
	//}

	//beego.Info("回调成功 订单成功")

	//type CallbackResponse struct {
	//	OutTradeNo    string `json:"out_trade_no"`   // 订单号
	//	ReturnMsg     string `json:"return_msg"`     // 是否成功
	//	AttachInfo    string `json:"attach_info"`    // 附加信息
	//	TransactionID string `json:"transaction_id"` // 微信支付订单号
	//	TradeNo       string `json:"trade_no"`       // 支付宝交易流水号
	//}

	if url != "" {
		//4.回调业务方「回调函数」
		callbackResponse := new(models.CallbackResponse)
		callbackResponse.ReturnMsg = "SUCCESS"
		//callbackResponse.OutTradeNo = input.OutTradeNo
		//callbackResponse.TransactionID = input.TransactionId
		callbackResponse.OutTradeNo = input.OutOrderNo //交易凭据单号 todo ?
		//callbackResponse.TransactionID = input.OutOrderNo //交易凭据单号 todo ? strconv.Itoa(

		OrderTradeInfo, _ := input.OrderTradeInfo.(map[string]interface{})
		if OrderTradeInfo["auth_code"] != nil {
			//LAKALA签约协议号列表
			callbackResponse.AuthCode = OrderTradeInfo["auth_code"].(string)
		}

		if OrderTradeInfo["acc_trade_no"] != nil {
			//账户端交易订单号
			callbackResponse.TransactionID = OrderTradeInfo["acc_trade_no"].(string)
		}

		if OrderTradeInfo["trade_no"] != nil {
			//交易流水号
			callbackResponse.TradeNo = OrderTradeInfo["trade_no"].(string)
		}

		attachMap := make(map[string]interface{}, 0)
		_ = json.Unmarshal([]byte(attach), &attachMap)
		if attachMap["store_sn"].(string) == "" {
			callbackResponse.AttachInfo = attachMap["old_attach"].(string)
		} else {
			callbackResponse.AttachInfo = attach  //商户订单号（谛宝多多）
		}
		//fmt.Println("444444444444444444444444444")
		//fmt.Println(callbackResponse)
		go callBackBusinessService(input.OutOrderNo, url, callbackResponse)

	}

	response.Code = "SUCCESS"
	response.Message = "执行成功"
	InsertPayBillDetailNoticeResponseBody(tx, billID, response)
	return response, nil
}

// 拉卡拉支付回调(扫码)
func ScanNotice(input *models.ScanNoticeInput) (*base.ResponseDataWxNotice, error) {

	fmt.Println("拉卡拉回调(扫码)输入参数")
	fmt.Println(input)

	response := new(base.ResponseDataWxNotice)

	//db, err := mysql.NewShopConn()
	//if err != nil {
	//	response.Code = "FAIL"
	//	response.Message = "参数格式校验错误"
	//	return response, err
	//}

	// 插入数据库
	db, err := mysql.NewPayConn()
	if err != nil {
		return response, err
	}

	tx, err := db.Begin()
	if err != nil {
		return response, err
	}

	defer mysql.CloseTx(tx, err)

	fmt.Println("111")

	//1.订单存在check
	var billID int64
	var attach, url string
	err = db.QueryRow("select ifnull(id, 0), attach, notify_pay_url from system_pay_bill where payment_order_code = ?",
		input.OutTradeNo).Scan(&billID, &attach, &url)
	if err != nil || billID == 0 || billID == 2 {
		response.Code = "FAIL"
		response.Message = "db operation fail1"
		return response, err
	}

	fmt.Println("222")

	//if noticeRequest.ReturnCode == "SUCCESS" {
	// 把订单状态置为 结算成功
	err = BillPayStateSuccess(tx, billID)
	if err != nil {
		//beego.Error("微信回调, 根据订单id 把订单置为结算成功 失败: ", err)
		//response.ReturnCode = "FAIL"
		//response.ReturnMsg = "db operation fail"
		//return response, nil
		response.Code = "FAIL"
		response.Message = "db operation fail2"
		InsertPayBillDetailNoticeResponseBody(tx, billID, response)
		return response, err
	}
	//} else {
	//
	//	// 把订单状态置为 结算失败
	//	err = repository.BillPayStateFail(tx, billID)
	//	if err != nil {
	//		beego.Error("微信回调, 根据订单id 把订单置为结算成功 失败: ", err)
	//		response.ReturnCode = "FAIL"
	//		response.ReturnMsg = "db operation fail"
	//		return response, nil
	//	}
	//}

	//2.「拉卡拉返回数据」存入 notice_request_body
	err = InsertPayBillDetailNoticeRequestBody(tx, billID, input)
	if err != nil {
		//beego.Error("微信回调, 根据订单id 插入回调Request参数 失败: ", err)
		response.Code = "FAIL"
		response.Message = "db operation fail3"
		InsertPayBillDetailNoticeResponseBody(tx, billID, response)
		return response, err
	}

	fmt.Println("333")

	//3.拉卡拉订收银台订单查询 - check todo

	//3.存入 notice_response_body
	//err = InsertPayBillDetailNoticeResponseBody(billID, response)
	//if err != nil {
	//	beego.Error("微信回调, 根据订单id 插入回调Response参数 失败: ", err)
	//	response.ReturnCode = "FAIL"
	//	response.ReturnMsg = "db operation fail"
	//	return err
	//}

	//beego.Info("回调成功 订单成功")

	//type CallbackResponse struct {
	//	OutTradeNo    string `json:"out_trade_no"`   // 订单号
	//	ReturnMsg     string `json:"return_msg"`     // 是否成功
	//	AttachInfo    string `json:"attach_info"`    // 附加信息
	//	TransactionID string `json:"transaction_id"` // 微信支付订单号
	//	TradeNo       string `json:"trade_no"`       // 支付宝交易流水号
	//}

	if url != "" {
		//4.回调业务方「回调函数」
		callbackResponse := new(models.CallbackResponse)
		callbackResponse.ReturnMsg = "SUCCESS"
		//callbackResponse.OutTradeNo = input.OutTradeNo
		//callbackResponse.TransactionID = input.TransactionId
		callbackResponse.OutTradeNo = input.OutTradeNo //交易凭据单号 todo ?
		//callbackResponse.TransactionID = input.OutTradeNo //交易凭据单号 todo ? strconv.Itoa(

		//OrderTradeInfo, _ := input.OrderTradeInfo.(map[string]interface{})
		//if OrderTradeInfo["auth_code"] != nil {
		//	//LAKALA签约协议号列表
		//	callbackResponse.AuthCode = OrderTradeInfo["auth_code"].(string)
		//}

		//账户端交易订单号
		callbackResponse.TransactionID = input.AccTradeNo

		//交易流水号
		callbackResponse.TradeNo = input.TradeNo

		attachMap := make(map[string]interface{}, 0)
		_ = json.Unmarshal([]byte(attach), &attachMap)
		if attachMap["store_sn"].(string) == "" {
			callbackResponse.AttachInfo = attachMap["old_attach"].(string)
		} else {
			callbackResponse.AttachInfo = attach  //商户订单号（谛宝多多）
		}
		//fmt.Println("444444444444444444444444444")
		//fmt.Println(callbackResponse)
		go callBackBusinessService(input.OutTradeNo, url, callbackResponse)

	}

	response.Code = "SUCCESS"
	response.Message = "执行成功"
	InsertPayBillDetailNoticeResponseBody(tx, billID, response)
	return response, nil
}

// InsertPayBillDetailNoticeRequestBody is 插入支付订单详情表中的 下单参数字段 notice_request_body
func InsertPayBillDetailNoticeRequestBody(tx *sql.Tx, billID int64, noticeRequestBody interface{}) error {

	body, err := json.Marshal(noticeRequestBody)
	if err != nil {
		return err
	}
	insertPayBillDetailSQL := `update system_pay_bill_detail set notice_request_body = ? where pay_bill_id = ?`
	result, err := tx.Exec(insertPayBillDetailSQL, string(body), billID)
	if err != nil {
		return err
	}

	_, err = result.RowsAffected()
	if err != nil {
		return err
	}
	return nil
}

// InsertPayBillDetailNoticeResponseBody is 插入支付订单详情表中的 下单参数字段 notice_response_body
func InsertPayBillDetailNoticeResponseBody(tx *sql.Tx, billID int64, noticeResponseBody interface{}) error {

	body, err := json.Marshal(noticeResponseBody)
	if err != nil {
		return err
	}
	insertPayBillDetailSQL := `update system_pay_bill_detail set notice_response_body = ? where pay_bill_id = ?`
	result, err := tx.Exec(insertPayBillDetailSQL, string(body), billID)
	if err != nil {
		return err
	}

	_, err = result.RowsAffected()
	if err != nil {
		return err
	}
	return nil
}

// BillPayStateSuccess is 微信回调后 把订单状态 置为结算成功
func BillPayStateSuccess(tx *sql.Tx, billID int64) error {

	insertPayBillDetailSQL := `update system_pay_bill set result_code = 1 where id = ?`
	result, err := tx.Exec(insertPayBillDetailSQL, billID)
	if err != nil {
		return err
	}

	_, err = result.RowsAffected()
	if err != nil {
		return err
	}
	return nil
}

// BillPayStateFail is 微信回调后 把订单状态 置为结算失败
//func BillPayStateFail(tx *sql.Tx, billID int64) error {
//
//	insertPayBillDetailSQL := `update system_pay_bill set result_code = 2 where id = ?`
//	result, err := tx.Exec(insertPayBillDetailSQL, billID)
//	if err != nil {
//		return err
//	}
//
//	_, err = result.RowsAffected()
//	if err != nil {
//		return err
//	}
//	return nil
//}

