package routers

import (
	"github.com/gin-gonic/gin"
	ginSwagger "github.com/swaggo/gin-swagger"
	"github.com/swaggo/gin-swagger/swaggerFiles"
	v1_router "system_pay/router/v1"
)

// InitRouter 注册路由
func InitRouter() *gin.Engine {

	if gin.Mode() == gin.ReleaseMode {
		gin.SetMode(gin.ReleaseMode) // gin设置成发布模式
	}

	r := gin.Default()

	//  测试与开发状态启用swagger
	if gin.Mode() == gin.TestMode || gin.Mode() == gin.DebugMode {
		r.GET("/swagger/*any", ginSwagger.WrapHandler(swaggerFiles.Handler))
	}

	// 发布后禁用swagger
	if gin.Mode() == gin.ReleaseMode {
		r.GET("/swagger/*any", ginSwagger.DisablingWrapHandler(swaggerFiles.Handler, "NAME_OF_ENV_VARIABLE"))
	}

	// 拉卡拉统一支付
	v1_router.PayRouter(r)

	return r
}
